package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RejectTransitGatewayVpcAttachmentResponse(
    transitGatewayVpcAttachment: Option[
      zio.aws.ec2.model.TransitGatewayVpcAttachment
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse = {
    import RejectTransitGatewayVpcAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayVpcAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayVpcAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse
      .wrap(buildAwsValue())
}
object RejectTransitGatewayVpcAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse =
      zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse(
        transitGatewayVpcAttachment.map(value => value.asEditable)
      )
    def transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly]
    def getTransitGatewayVpcAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayVpcAttachment",
      transitGatewayVpcAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse
  ) extends zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly {
    override val transitGatewayVpcAttachment
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly] = scala
      .Option(impl.transitGatewayVpcAttachment())
      .map(value => zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse
  ): zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
