package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ProtocolValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.ProtocolValue
}
object ProtocolValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ProtocolValue
  ): zio.aws.ec2.model.ProtocolValue = value match {
    case software.amazon.awssdk.services.ec2.model.ProtocolValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ProtocolValue.GRE =>
      val r = gre
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ProtocolValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ProtocolValue =
      software.amazon.awssdk.services.ec2.model.ProtocolValue.UNKNOWN_TO_SDK_VERSION
  }
  case object gre extends zio.aws.ec2.model.ProtocolValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ProtocolValue =
      software.amazon.awssdk.services.ec2.model.ProtocolValue.GRE
  }
}
