package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase2DHGroupNumbersListValue(value: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue = {
    import Phase2DHGroupNumbersListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue
      .builder()
      .optionallyWith(
        value.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly =
    zio.aws.ec2.model.Phase2DHGroupNumbersListValue.wrap(buildAwsValue())
}
object Phase2DHGroupNumbersListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase2DHGroupNumbersListValue =
      zio.aws.ec2.model.Phase2DHGroupNumbersListValue(value.map(value => value))
    def value: Option[Integer]
    def getValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue
  ) extends zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly {
    override val value: Option[Integer] = scala
      .Option(impl.value())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue
  ): zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly = new Wrapper(
    impl
  )
}
