package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase1IntegrityAlgorithmsListValue(
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue = {
    import Phase1IntegrityAlgorithmsListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly =
    zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.wrap(buildAwsValue())
}
object Phase1IntegrityAlgorithmsListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue =
      zio.aws.ec2.model
        .Phase1IntegrityAlgorithmsListValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue
  ) extends zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue
  ): zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly =
    new Wrapper(impl)
}
