package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PacketHeaderStatement(
    sourceAddresses: Option[Iterable[String]] = None,
    destinationAddresses: Option[Iterable[String]] = None,
    sourcePorts: Option[Iterable[String]] = None,
    destinationPorts: Option[Iterable[String]] = None,
    sourcePrefixLists: Option[Iterable[String]] = None,
    destinationPrefixLists: Option[Iterable[String]] = None,
    protocols: Option[Iterable[zio.aws.ec2.model.Protocol]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PacketHeaderStatement = {
    import PacketHeaderStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PacketHeaderStatement
      .builder()
      .optionallyWith(
        sourceAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceAddresses)
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        sourcePrefixLists.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourcePrefixLists)
      .optionallyWith(
        destinationPrefixLists.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationPrefixLists)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PacketHeaderStatement.ReadOnly =
    zio.aws.ec2.model.PacketHeaderStatement.wrap(buildAwsValue())
}
object PacketHeaderStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PacketHeaderStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PacketHeaderStatement =
      zio.aws.ec2.model.PacketHeaderStatement(
        sourceAddresses.map(value => value),
        destinationAddresses.map(value => value),
        sourcePorts.map(value => value),
        destinationPorts.map(value => value),
        sourcePrefixLists.map(value => value),
        destinationPrefixLists.map(value => value),
        protocols.map(value => value)
      )
    def sourceAddresses: Option[List[String]]
    def destinationAddresses: Option[List[String]]
    def sourcePorts: Option[List[String]]
    def destinationPorts: Option[List[String]]
    def sourcePrefixLists: Option[List[String]]
    def destinationPrefixLists: Option[List[String]]
    def protocols: Option[List[zio.aws.ec2.model.Protocol]]
    def getSourceAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceAddresses", sourceAddresses)
    def getDestinationAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getSourcePorts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getSourcePrefixLists: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourcePrefixLists", sourcePrefixLists)
    def getDestinationPrefixLists: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("destinationPrefixLists", destinationPrefixLists)
    def getProtocols: ZIO[Any, AwsError, List[zio.aws.ec2.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PacketHeaderStatement
  ) extends zio.aws.ec2.model.PacketHeaderStatement.ReadOnly {
    override val sourceAddresses: Option[List[String]] = scala
      .Option(impl.sourceAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinationAddresses: Option[List[String]] = scala
      .Option(impl.destinationAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sourcePorts: Option[List[String]] = scala
      .Option(impl.sourcePorts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinationPorts: Option[List[String]] = scala
      .Option(impl.destinationPorts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sourcePrefixLists: Option[List[String]] = scala
      .Option(impl.sourcePrefixLists())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinationPrefixLists: Option[List[String]] = scala
      .Option(impl.destinationPrefixLists())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val protocols: Option[List[zio.aws.ec2.model.Protocol]] = scala
      .Option(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Protocol.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PacketHeaderStatement
  ): zio.aws.ec2.model.PacketHeaderStatement.ReadOnly = new Wrapper(impl)
}
