package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MoveAddressToVpcResponse(
    allocationId: Option[String] = None,
    status: Option[zio.aws.ec2.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse = {
    import MoveAddressToVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse
      .builder()
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly =
    zio.aws.ec2.model.MoveAddressToVpcResponse.wrap(buildAwsValue())
}
object MoveAddressToVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MoveAddressToVpcResponse =
      zio.aws.ec2.model.MoveAddressToVpcResponse(
        allocationId.map(value => value),
        status.map(value => value)
      )
    def allocationId: Option[String]
    def status: Option[zio.aws.ec2.model.Status]
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse
  ) extends zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly {
    override val allocationId: Option[String] =
      scala.Option(impl.allocationId()).map(value => value: String)
    override val status: Option[zio.aws.ec2.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse
  ): zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly = new Wrapper(impl)
}
