package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyAvailabilityZoneGroupRequest(
    groupName: String,
    optInStatus: zio.aws.ec2.model.ModifyAvailabilityZoneOptInStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest = {
    import ModifyAvailabilityZoneGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest
      .builder()
      .groupName(groupName: java.lang.String)
      .optInStatus(optInStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest.ReadOnly =
    zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest.wrap(buildAwsValue())
}
object ModifyAvailabilityZoneGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest =
      zio.aws.ec2.model
        .ModifyAvailabilityZoneGroupRequest(groupName, optInStatus)
    def groupName: String
    def optInStatus: zio.aws.ec2.model.ModifyAvailabilityZoneOptInStatus
    def getGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(groupName)
    def getOptInStatus: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ModifyAvailabilityZoneOptInStatus
    ] = ZIO.succeed(optInStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest
  ) extends zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest.ReadOnly {
    override val groupName: String = impl.groupName(): String
    override val optInStatus
        : zio.aws.ec2.model.ModifyAvailabilityZoneOptInStatus =
      zio.aws.ec2.model.ModifyAvailabilityZoneOptInStatus
        .wrap(impl.optInStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest
  ): zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest.ReadOnly =
    new Wrapper(impl)
}
