package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateOverrides(
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    spotPrice: Option[String] = None,
    subnetId: Option[SubnetId] = None,
    availabilityZone: Option[String] = None,
    weightedCapacity: Option[Double] = None,
    priority: Option[Double] = None,
    instanceRequirements: Option[zio.aws.ec2.model.InstanceRequirements] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides = {
    import LaunchTemplateOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(priority.map(value => value: java.lang.Double))(
        _.priority
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateOverrides.wrap(buildAwsValue())
}
object LaunchTemplateOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateOverrides =
      zio.aws.ec2.model.LaunchTemplateOverrides(
        instanceType.map(value => value),
        spotPrice.map(value => value),
        subnetId.map(value => value),
        availabilityZone.map(value => value),
        weightedCapacity.map(value => value),
        priority.map(value => value),
        instanceRequirements.map(value => value.asEditable)
      )
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def spotPrice: Option[String]
    def subnetId: Option[SubnetId]
    def availabilityZone: Option[String]
    def weightedCapacity: Option[Double]
    def priority: Option[Double]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getPriority: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("priority", priority)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ) extends zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly {
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val spotPrice: Option[String] =
      scala.Option(impl.spotPrice()).map(value => value: String)
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val weightedCapacity: Option[Double] =
      scala.Option(impl.weightedCapacity()).map(value => value: Double)
    override val priority: Option[Double] =
      scala.Option(impl.priority()).map(value => value: Double)
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides
  ): zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly = new Wrapper(impl)
}
