package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Ipv6PrefixSpecificationResponse(
    ipv6Prefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse = {
    import Ipv6PrefixSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse
      .builder()
      .optionallyWith(ipv6Prefix.map(value => value: java.lang.String))(
        _.ipv6Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.wrap(buildAwsValue())
}
object Ipv6PrefixSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv6PrefixSpecificationResponse =
      zio.aws.ec2.model
        .Ipv6PrefixSpecificationResponse(ipv6Prefix.map(value => value))
    def ipv6Prefix: Option[String]
    def getIpv6Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Prefix", ipv6Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse
  ) extends zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly {
    override val ipv6Prefix: Option[String] =
      scala.Option(impl.ipv6Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse
  ): zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly = new Wrapper(
    impl
  )
}
