package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class IpamAddressHistoryRecord(
    resourceOwnerId: Option[String] = None,
    resourceRegion: Option[String] = None,
    resourceType: Option[zio.aws.ec2.model.IpamAddressHistoryResourceType] =
      None,
    resourceId: Option[String] = None,
    resourceCidr: Option[String] = None,
    resourceName: Option[String] = None,
    resourceComplianceStatus: Option[zio.aws.ec2.model.IpamComplianceStatus] =
      None,
    resourceOverlapStatus: Option[zio.aws.ec2.model.IpamOverlapStatus] = None,
    vpcId: Option[String] = None,
    sampledStartTime: Option[MillisecondDateTime] = None,
    sampledEndTime: Option[MillisecondDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord = {
    import IpamAddressHistoryRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
      .builder()
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceCidr.map(value => value: java.lang.String))(
        _.resourceCidr
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceComplianceStatus.map(value => value.unwrap))(
        _.resourceComplianceStatus
      )
      .optionallyWith(resourceOverlapStatus.map(value => value.unwrap))(
        _.resourceOverlapStatus
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        sampledStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.sampledStartTime)
      .optionallyWith(
        sampledEndTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.sampledEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly =
    zio.aws.ec2.model.IpamAddressHistoryRecord.wrap(buildAwsValue())
}
object IpamAddressHistoryRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamAddressHistoryRecord =
      zio.aws.ec2.model.IpamAddressHistoryRecord(
        resourceOwnerId.map(value => value),
        resourceRegion.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceCidr.map(value => value),
        resourceName.map(value => value),
        resourceComplianceStatus.map(value => value),
        resourceOverlapStatus.map(value => value),
        vpcId.map(value => value),
        sampledStartTime.map(value => value),
        sampledEndTime.map(value => value)
      )
    def resourceOwnerId: Option[String]
    def resourceRegion: Option[String]
    def resourceType: Option[zio.aws.ec2.model.IpamAddressHistoryResourceType]
    def resourceId: Option[String]
    def resourceCidr: Option[String]
    def resourceName: Option[String]
    def resourceComplianceStatus: Option[zio.aws.ec2.model.IpamComplianceStatus]
    def resourceOverlapStatus: Option[zio.aws.ec2.model.IpamOverlapStatus]
    def vpcId: Option[String]
    def sampledStartTime: Option[MillisecondDateTime]
    def sampledEndTime: Option[MillisecondDateTime]
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamAddressHistoryResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceCidr", resourceCidr)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceComplianceStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamComplianceStatus] = AwsError
      .unwrapOptionField("resourceComplianceStatus", resourceComplianceStatus)
    def getResourceOverlapStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamOverlapStatus] =
      AwsError.unwrapOptionField("resourceOverlapStatus", resourceOverlapStatus)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSampledStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("sampledStartTime", sampledStartTime)
    def getSampledEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("sampledEndTime", sampledEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ) extends zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly {
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val resourceRegion: Option[String] =
      scala.Option(impl.resourceRegion()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.IpamAddressHistoryResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.IpamAddressHistoryResourceType.wrap(value)
      )
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceCidr: Option[String] =
      scala.Option(impl.resourceCidr()).map(value => value: String)
    override val resourceName: Option[String] =
      scala.Option(impl.resourceName()).map(value => value: String)
    override val resourceComplianceStatus
        : Option[zio.aws.ec2.model.IpamComplianceStatus] = scala
      .Option(impl.resourceComplianceStatus())
      .map(value => zio.aws.ec2.model.IpamComplianceStatus.wrap(value))
    override val resourceOverlapStatus
        : Option[zio.aws.ec2.model.IpamOverlapStatus] = scala
      .Option(impl.resourceOverlapStatus())
      .map(value => zio.aws.ec2.model.IpamOverlapStatus.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val sampledStartTime: Option[MillisecondDateTime] = scala
      .Option(impl.sampledStartTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val sampledEndTime: Option[MillisecondDateTime] = scala
      .Option(impl.sampledEndTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord
  ): zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly = new Wrapper(impl)
}
