package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceIpv4Prefix(ipv4Prefix: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix = {
    import InstanceIpv4Prefix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix
      .builder()
      .optionallyWith(ipv4Prefix.map(value => value: java.lang.String))(
        _.ipv4Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly =
    zio.aws.ec2.model.InstanceIpv4Prefix.wrap(buildAwsValue())
}
object InstanceIpv4Prefix {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceIpv4Prefix =
      zio.aws.ec2.model.InstanceIpv4Prefix(ipv4Prefix.map(value => value))
    def ipv4Prefix: Option[String]
    def getIpv4Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Prefix", ipv4Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix
  ) extends zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly {
    override val ipv4Prefix: Option[String] =
      scala.Option(impl.ipv4Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix
  ): zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly = new Wrapper(impl)
}
