package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DestinationOptionsResponse(
    fileFormat: Option[zio.aws.ec2.model.DestinationFileFormat] = None,
    hiveCompatiblePartitions: Option[Boolean] = None,
    perHourPartition: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DestinationOptionsResponse = {
    import DestinationOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DestinationOptionsResponse
      .builder()
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        hiveCompatiblePartitions.map(value => value: java.lang.Boolean)
      )(_.hiveCompatiblePartitions)
      .optionallyWith(perHourPartition.map(value => value: java.lang.Boolean))(
        _.perHourPartition
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly =
    zio.aws.ec2.model.DestinationOptionsResponse.wrap(buildAwsValue())
}
object DestinationOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DestinationOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DestinationOptionsResponse =
      zio.aws.ec2.model.DestinationOptionsResponse(
        fileFormat.map(value => value),
        hiveCompatiblePartitions.map(value => value),
        perHourPartition.map(value => value)
      )
    def fileFormat: Option[zio.aws.ec2.model.DestinationFileFormat]
    def hiveCompatiblePartitions: Option[Boolean]
    def perHourPartition: Option[Boolean]
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.DestinationFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getHiveCompatiblePartitions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("hiveCompatiblePartitions", hiveCompatiblePartitions)
    def getPerHourPartition: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("perHourPartition", perHourPartition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DestinationOptionsResponse
  ) extends zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly {
    override val fileFormat: Option[zio.aws.ec2.model.DestinationFileFormat] =
      scala
        .Option(impl.fileFormat())
        .map(value => zio.aws.ec2.model.DestinationFileFormat.wrap(value))
    override val hiveCompatiblePartitions: Option[Boolean] =
      scala.Option(impl.hiveCompatiblePartitions()).map(value => value: Boolean)
    override val perHourPartition: Option[Boolean] =
      scala.Option(impl.perHourPartition()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DestinationOptionsResponse
  ): zio.aws.ec2.model.DestinationOptionsResponse.ReadOnly = new Wrapper(impl)
}
