package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServicePermissionsResponse(
    allowedPrincipals: Option[Iterable[zio.aws.ec2.model.AllowedPrincipal]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse = {
    import DescribeVpcEndpointServicePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
      .builder()
      .optionallyWith(
        allowedPrincipals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedPrincipals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServicePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse(
        allowedPrincipals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def allowedPrincipals
        : Option[List[zio.aws.ec2.model.AllowedPrincipal.ReadOnly]]
    def nextToken: Option[String]
    def getAllowedPrincipals: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AllowedPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField("allowedPrincipals", allowedPrincipals)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly {
    override val allowedPrincipals
        : Option[List[zio.aws.ec2.model.AllowedPrincipal.ReadOnly]] = scala
      .Option(impl.allowedPrincipals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AllowedPrincipal.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
