package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupReferencesResponse(
    securityGroupReferenceSet: Option[
      Iterable[zio.aws.ec2.model.SecurityGroupReference]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse = {
    import DescribeSecurityGroupReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse
      .builder()
      .optionallyWith(
        securityGroupReferenceSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupReferenceSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse
      .wrap(buildAwsValue())
}
object DescribeSecurityGroupReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse =
      zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse(
        securityGroupReferenceSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def securityGroupReferenceSet
        : Option[List[zio.aws.ec2.model.SecurityGroupReference.ReadOnly]]
    def getSecurityGroupReferenceSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "securityGroupReferenceSet",
      securityGroupReferenceSet
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse
  ) extends zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly {
    override val securityGroupReferenceSet
        : Option[List[zio.aws.ec2.model.SecurityGroupReference.ReadOnly]] =
      scala
        .Option(impl.securityGroupReferenceSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SecurityGroupReference.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse
  ): zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly =
    new Wrapper(impl)
}
