package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ScheduledInstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeScheduledInstancesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    scheduledInstanceIds: Option[Iterable[ScheduledInstanceId]] = None,
    slotStartTimeRange: Option[zio.aws.ec2.model.SlotStartTimeRangeRequest] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest = {
    import DescribeScheduledInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        scheduledInstanceIds.map(value =>
          value.map { item =>
            ScheduledInstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scheduledInstanceIds)
      .optionallyWith(slotStartTimeRange.map(value => value.buildAwsValue()))(
        _.slotStartTimeRange
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeScheduledInstancesRequest.wrap(buildAwsValue())
}
object DescribeScheduledInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeScheduledInstancesRequest =
      zio.aws.ec2.model.DescribeScheduledInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        scheduledInstanceIds.map(value => value),
        slotStartTimeRange.map(value => value.asEditable)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def scheduledInstanceIds: Option[List[ScheduledInstanceId]]
    def slotStartTimeRange
        : Option[zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduledInstanceIds: ZIO[Any, AwsError, List[ScheduledInstanceId]] =
      AwsError.unwrapOptionField("scheduledInstanceIds", scheduledInstanceIds)
    def getSlotStartTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("slotStartTimeRange", slotStartTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ) extends zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val scheduledInstanceIds: Option[List[ScheduledInstanceId]] = scala
      .Option(impl.scheduledInstanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ScheduledInstanceId(item)
        }.toList
      )
    override val slotStartTimeRange
        : Option[zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly] = scala
      .Option(impl.slotStartTimeRange())
      .map(value => zio.aws.ec2.model.SlotStartTimeRangeRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ): zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
