package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeRegionsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    regionNames: Option[Iterable[String]] = None,
    allRegions: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest = {
    import DescribeRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        regionNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regionNames)
      .optionallyWith(allRegions.map(value => value: java.lang.Boolean))(
        _.allRegions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeRegionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeRegionsRequest.wrap(buildAwsValue())
}
object DescribeRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeRegionsRequest =
      zio.aws.ec2.model.DescribeRegionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        regionNames.map(value => value),
        allRegions.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def regionNames: Option[List[String]]
    def allRegions: Option[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getRegionNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regionNames", regionNames)
    def getAllRegions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allRegions", allRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest
  ) extends zio.aws.ec2.model.DescribeRegionsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val regionNames: Option[List[String]] = scala
      .Option(impl.regionNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allRegions: Option[Boolean] =
      scala.Option(impl.allRegions()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest
  ): zio.aws.ec2.model.DescribeRegionsRequest.ReadOnly = new Wrapper(impl)
}
