package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIpamScopesResponse(
    nextToken: Option[NextToken] = None,
    ipamScopes: Option[Iterable[zio.aws.ec2.model.IpamScope]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse = {
    import DescribeIpamScopesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipamScopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamScopes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamScopesResponse.wrap(buildAwsValue())
}
object DescribeIpamScopesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpamScopesResponse =
      zio.aws.ec2.model.DescribeIpamScopesResponse(
        nextToken.map(value => value),
        ipamScopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def ipamScopes: Option[List[zio.aws.ec2.model.IpamScope.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamScopes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamScope.ReadOnly]] =
      AwsError.unwrapOptionField("ipamScopes", ipamScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse
  ) extends zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamScopes
        : Option[List[zio.aws.ec2.model.IpamScope.ReadOnly]] = scala
      .Option(impl.ipamScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamScope.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse
  ): zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly = new Wrapper(impl)
}
