package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeInternetGatewaysMaxResults,
  InternetGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInternetGatewaysRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    internetGatewayIds: Option[Iterable[InternetGatewayId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeInternetGatewaysMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest = {
    import DescribeInternetGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        internetGatewayIds.map(value =>
          value.map { item =>
            InternetGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.internetGatewayIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeInternetGatewaysMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInternetGatewaysRequest.wrap(buildAwsValue())
}
object DescribeInternetGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInternetGatewaysRequest =
      zio.aws.ec2.model.DescribeInternetGatewaysRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def internetGatewayIds: Option[List[InternetGatewayId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeInternetGatewaysMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getInternetGatewayIds: ZIO[Any, AwsError, List[InternetGatewayId]] =
      AwsError.unwrapOptionField("internetGatewayIds", internetGatewayIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeInternetGatewaysMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val internetGatewayIds: Option[List[InternetGatewayId]] = scala
      .Option(impl.internetGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InternetGatewayId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeInternetGatewaysMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeInternetGatewaysMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest
  ): zio.aws.ec2.model.DescribeInternetGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
