package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceTypeOfferingsResponse(
    instanceTypeOfferings: Option[
      Iterable[zio.aws.ec2.model.InstanceTypeOffering]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse = {
    import DescribeInstanceTypeOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse
      .builder()
      .optionallyWith(
        instanceTypeOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeOfferings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceTypeOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse =
      zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse(
        instanceTypeOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceTypeOfferings
        : Option[List[zio.aws.ec2.model.InstanceTypeOffering.ReadOnly]]
    def nextToken: Option[NextToken]
    def getInstanceTypeOfferings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceTypeOffering.ReadOnly
    ]] =
      AwsError.unwrapOptionField("instanceTypeOfferings", instanceTypeOfferings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse
  ) extends zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly {
    override val instanceTypeOfferings
        : Option[List[zio.aws.ec2.model.InstanceTypeOffering.ReadOnly]] = scala
      .Option(impl.instanceTypeOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceTypeOffering.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse
  ): zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
