package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeElasticGpusMaxResults,
  ElasticGpuId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeElasticGpusRequest(
    elasticGpuIds: Option[Iterable[ElasticGpuId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DescribeElasticGpusMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest = {
    import DescribeElasticGpusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest
      .builder()
      .optionallyWith(
        elasticGpuIds.map(value =>
          value.map { item =>
            ElasticGpuId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.elasticGpuIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeElasticGpusMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeElasticGpusRequest.ReadOnly =
    zio.aws.ec2.model.DescribeElasticGpusRequest.wrap(buildAwsValue())
}
object DescribeElasticGpusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeElasticGpusRequest =
      zio.aws.ec2.model.DescribeElasticGpusRequest(
        elasticGpuIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def elasticGpuIds: Option[List[ElasticGpuId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DescribeElasticGpusMaxResults]
    def nextToken: Option[String]
    def getElasticGpuIds: ZIO[Any, AwsError, List[ElasticGpuId]] =
      AwsError.unwrapOptionField("elasticGpuIds", elasticGpuIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DescribeElasticGpusMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest
  ) extends zio.aws.ec2.model.DescribeElasticGpusRequest.ReadOnly {
    override val elasticGpuIds: Option[List[ElasticGpuId]] = scala
      .Option(impl.elasticGpuIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ElasticGpuId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DescribeElasticGpusMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeElasticGpusMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest
  ): zio.aws.ec2.model.DescribeElasticGpusRequest.ReadOnly = new Wrapper(impl)
}
