package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAddressesAttributeResponse(
    addresses: Option[Iterable[zio.aws.ec2.model.AddressAttribute]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse = {
    import DescribeAddressesAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
      .builder()
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesAttributeResponse.wrap(buildAwsValue())
}
object DescribeAddressesAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesAttributeResponse =
      zio.aws.ec2.model.DescribeAddressesAttributeResponse(
        addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addresses: Option[List[zio.aws.ec2.model.AddressAttribute.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddressAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("addresses", addresses)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ) extends zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly {
    override val addresses
        : Option[List[zio.aws.ec2.model.AddressAttribute.ReadOnly]] = scala
      .Option(impl.addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AddressAttribute.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ): zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
