package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamScopeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIpamScopeRequest(ipamScopeId: IpamScopeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest = {
    import DeleteIpamScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
      .builder()
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamScopeRequest.wrap(buildAwsValue())
}
object DeleteIpamScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamScopeRequest =
      zio.aws.ec2.model.DeleteIpamScopeRequest(ipamScopeId)
    def ipamScopeId: IpamScopeId
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ) extends zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly {
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ): zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly = new Wrapper(impl)
}
