package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSubnetResponse(
    subnet: Option[zio.aws.ec2.model.Subnet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSubnetResponse = {
    import CreateSubnetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSubnetResponse
      .builder()
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSubnetResponse.ReadOnly =
    zio.aws.ec2.model.CreateSubnetResponse.wrap(buildAwsValue())
}
object CreateSubnetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSubnetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSubnetResponse = zio.aws.ec2.model
      .CreateSubnetResponse(subnet.map(value => value.asEditable))
    def subnet: Option[zio.aws.ec2.model.Subnet.ReadOnly]
    def getSubnet: ZIO[Any, AwsError, zio.aws.ec2.model.Subnet.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetResponse
  ) extends zio.aws.ec2.model.CreateSubnetResponse.ReadOnly {
    override val subnet: Option[zio.aws.ec2.model.Subnet.ReadOnly] = scala
      .Option(impl.subnet())
      .map(value => zio.aws.ec2.model.Subnet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetResponse
  ): zio.aws.ec2.model.CreateSubnetResponse.ReadOnly = new Wrapper(impl)
}
