package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnEndpointStatus(
    code: Option[zio.aws.ec2.model.ClientVpnEndpointStatusCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus = {
    import ClientVpnEndpointStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly =
    zio.aws.ec2.model.ClientVpnEndpointStatus.wrap(buildAwsValue())
}
object ClientVpnEndpointStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnEndpointStatus =
      zio.aws.ec2.model.ClientVpnEndpointStatus(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.ec2.model.ClientVpnEndpointStatusCode]
    def message: Option[String]
    def getCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnEndpointStatusCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus
  ) extends zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly {
    override val code: Option[zio.aws.ec2.model.ClientVpnEndpointStatusCode] =
      scala
        .Option(impl.code())
        .map(value => zio.aws.ec2.model.ClientVpnEndpointStatusCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus
  ): zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly = new Wrapper(impl)
}
