package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassicLinkInstance(
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    instanceId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClassicLinkInstance = {
    import ClassicLinkInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClassicLinkInstance
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClassicLinkInstance.ReadOnly =
    zio.aws.ec2.model.ClassicLinkInstance.wrap(buildAwsValue())
}
object ClassicLinkInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClassicLinkInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClassicLinkInstance =
      zio.aws.ec2.model.ClassicLinkInstance(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def instanceId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Option[String]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLinkInstance
  ) extends zio.aws.ec2.model.ClassicLinkInstance.ReadOnly {
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLinkInstance
  ): zio.aws.ec2.model.ClassicLinkInstance.ReadOnly = new Wrapper(impl)
}
