package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeClientVpnIngressResponse(
    status: Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse = {
    import AuthorizeClientVpnIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly =
    zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.wrap(buildAwsValue())
}
object AuthorizeClientVpnIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeClientVpnIngressResponse =
      zio.aws.ec2.model.AuthorizeClientVpnIngressResponse(
        status.map(value => value.asEditable)
      )
    def status
        : Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse
  ) extends zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly {
    override val status
        : Option[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse
  ): zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly = new Wrapper(
    impl
  )
}
