package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AcceleratorManufacturer {
  def unwrap: software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer
}
object AcceleratorManufacturer {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer
  ): zio.aws.ec2.model.AcceleratorManufacturer = value match {
    case software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.NVIDIA =>
      val r = nvidia
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.AMD =>
      val r = amd
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.AMAZON_WEB_SERVICES =>
      val r = `amazon-web-services`
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.XILINX =>
      val r = xilinx
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AcceleratorManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer =
      software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.UNKNOWN_TO_SDK_VERSION
  }
  case object nvidia extends zio.aws.ec2.model.AcceleratorManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer =
      software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.NVIDIA
  }
  case object amd extends zio.aws.ec2.model.AcceleratorManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer =
      software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.AMD
  }
  case object `amazon-web-services`
      extends zio.aws.ec2.model.AcceleratorManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer =
      software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.AMAZON_WEB_SERVICES
  }
  case object xilinx extends zio.aws.ec2.model.AcceleratorManufacturer {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer =
      software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer.XILINX
  }
}
