package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SpotInstanceStatus(
    code: Option[String] = None,
    message: Option[String] = None,
    updateTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotInstanceStatus = {
    import SpotInstanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(updateTime.map(value => DateTime.unwrap(value): Instant))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotInstanceStatus.ReadOnly =
    zio.aws.ec2.model.SpotInstanceStatus.wrap(buildAwsValue())
}
object SpotInstanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotInstanceStatus =
      zio.aws.ec2.model.SpotInstanceStatus(
        code.map(value => value),
        message.map(value => value),
        updateTime.map(value => value)
      )
    def code: Option[String]
    def message: Option[String]
    def updateTime: Option[DateTime]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ) extends zio.aws.ec2.model.SpotInstanceStatus.ReadOnly {
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val updateTime: Option[DateTime] = scala
      .Option(impl.updateTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ): zio.aws.ec2.model.SpotInstanceStatus.ReadOnly = new Wrapper(impl)
}
