package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SpotInstanceInterruptionBehavior {
  def unwrap: software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior
}
object SpotInstanceInterruptionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior
  ): zio.aws.ec2.model.SpotInstanceInterruptionBehavior = value match {
    case software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.HIBERNATE =>
      val r = hibernate
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.STOP =>
      val r = stop
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.TERMINATE =>
      val r = terminate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.SpotInstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object hibernate
      extends zio.aws.ec2.model.SpotInstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.HIBERNATE
  }
  case object stop extends zio.aws.ec2.model.SpotInstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.STOP
  }
  case object terminate
      extends zio.aws.ec2.model.SpotInstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior.TERMINATE
  }
}
