package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseError(
    code: Option[zio.aws.ec2.model.LaunchTemplateErrorCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResponseError = {
    import ResponseError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResponseError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResponseError.ReadOnly =
    zio.aws.ec2.model.ResponseError.wrap(buildAwsValue())
}
object ResponseError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ResponseError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResponseError = zio.aws.ec2.model
      .ResponseError(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.ec2.model.LaunchTemplateErrorCode]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplateErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResponseError
  ) extends zio.aws.ec2.model.ResponseError.ReadOnly {
    override val code: Option[zio.aws.ec2.model.LaunchTemplateErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.ec2.model.LaunchTemplateErrorCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResponseError
  ): zio.aws.ec2.model.ResponseError.ReadOnly = new Wrapper(impl)
}
