package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedInstancesModificationResult(
    reservedInstancesId: Option[String] = None,
    targetConfiguration: Option[
      zio.aws.ec2.model.ReservedInstancesConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult = {
    import ReservedInstancesModificationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult
      .builder()
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesModificationResult.wrap(buildAwsValue())
}
object ReservedInstancesModificationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesModificationResult =
      zio.aws.ec2.model.ReservedInstancesModificationResult(
        reservedInstancesId.map(value => value),
        targetConfiguration.map(value => value.asEditable)
      )
    def reservedInstancesId: Option[String]
    def targetConfiguration
        : Option[zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly]
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult
  ) extends zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly {
    override val reservedInstancesId: Option[String] =
      scala.Option(impl.reservedInstancesId()).map(value => value: String)
    override val targetConfiguration
        : Option[zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly] =
      scala
        .Option(impl.targetConfiguration())
        .map(value =>
          zio.aws.ec2.model.ReservedInstancesConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult
  ): zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly =
    new Wrapper(impl)
}
