package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestSpotInstancesResponse(
    spotInstanceRequests: Option[
      Iterable[zio.aws.ec2.model.SpotInstanceRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse = {
    import RequestSpotInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse
      .builder()
      .optionallyWith(
        spotInstanceRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spotInstanceRequests)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly =
    zio.aws.ec2.model.RequestSpotInstancesResponse.wrap(buildAwsValue())
}
object RequestSpotInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotInstancesResponse =
      zio.aws.ec2.model.RequestSpotInstancesResponse(
        spotInstanceRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def spotInstanceRequests
        : Option[List[zio.aws.ec2.model.SpotInstanceRequest.ReadOnly]]
    def getSpotInstanceRequests: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotInstanceRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("spotInstanceRequests", spotInstanceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse
  ) extends zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly {
    override val spotInstanceRequests
        : Option[List[zio.aws.ec2.model.SpotInstanceRequest.ReadOnly]] = scala
      .Option(impl.spotInstanceRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SpotInstanceRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse
  ): zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly = new Wrapper(impl)
}
