package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RejectVpcPeeringConnectionResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse = {
    import RejectVpcPeeringConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly =
    zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.wrap(buildAwsValue())
}
object RejectVpcPeeringConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RejectVpcPeeringConnectionResponse =
      zio.aws.ec2.model
        .RejectVpcPeeringConnectionResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse
  ) extends zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse
  ): zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
