package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrivateDnsDetails(privateDnsName: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrivateDnsDetails = {
    import PrivateDnsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrivateDnsDetails
      .builder()
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrivateDnsDetails.ReadOnly =
    zio.aws.ec2.model.PrivateDnsDetails.wrap(buildAwsValue())
}
object PrivateDnsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrivateDnsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrivateDnsDetails =
      zio.aws.ec2.model.PrivateDnsDetails(privateDnsName.map(value => value))
    def privateDnsName: Option[String]
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsDetails
  ) extends zio.aws.ec2.model.PrivateDnsDetails.ReadOnly {
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsDetails
  ): zio.aws.ec2.model.PrivateDnsDetails.ReadOnly = new Wrapper(impl)
}
