package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase1EncryptionAlgorithmsListValue(
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue = {
    import Phase1EncryptionAlgorithmsListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly =
    zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.wrap(buildAwsValue())
}
object Phase1EncryptionAlgorithmsListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue =
      zio.aws.ec2.model
        .Phase1EncryptionAlgorithmsListValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue
  ) extends zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue
  ): zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly =
    new Wrapper(impl)
}
