package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NetworkPerformance,
  MaximumNetworkCards,
  MaxIpv4AddrPerInterface,
  MaxIpv6AddrPerInterface,
  EfaSupportedFlag,
  Ipv6Flag,
  MaxNetworkInterfaces,
  EncryptionInTransitSupported,
  DefaultNetworkCardIndex
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInfo(
    networkPerformance: Option[NetworkPerformance] = None,
    maximumNetworkInterfaces: Option[MaxNetworkInterfaces] = None,
    maximumNetworkCards: Option[MaximumNetworkCards] = None,
    defaultNetworkCardIndex: Option[DefaultNetworkCardIndex] = None,
    networkCards: Option[Iterable[zio.aws.ec2.model.NetworkCardInfo]] = None,
    ipv4AddressesPerInterface: Option[MaxIpv4AddrPerInterface] = None,
    ipv6AddressesPerInterface: Option[MaxIpv6AddrPerInterface] = None,
    ipv6Supported: Option[Ipv6Flag] = None,
    enaSupport: Option[zio.aws.ec2.model.EnaSupport] = None,
    efaSupported: Option[EfaSupportedFlag] = None,
    efaInfo: Option[zio.aws.ec2.model.EfaInfo] = None,
    encryptionInTransitSupported: Option[EncryptionInTransitSupported] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NetworkInfo = {
    import NetworkInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInfo
      .builder()
      .optionallyWith(
        networkPerformance.map(value =>
          NetworkPerformance.unwrap(value): java.lang.String
        )
      )(_.networkPerformance)
      .optionallyWith(
        maximumNetworkInterfaces.map(value =>
          MaxNetworkInterfaces.unwrap(value): Integer
        )
      )(_.maximumNetworkInterfaces)
      .optionallyWith(
        maximumNetworkCards.map(value =>
          MaximumNetworkCards.unwrap(value): Integer
        )
      )(_.maximumNetworkCards)
      .optionallyWith(
        defaultNetworkCardIndex.map(value =>
          DefaultNetworkCardIndex.unwrap(value): Integer
        )
      )(_.defaultNetworkCardIndex)
      .optionallyWith(
        networkCards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkCards)
      .optionallyWith(
        ipv4AddressesPerInterface.map(value =>
          MaxIpv4AddrPerInterface.unwrap(value): Integer
        )
      )(_.ipv4AddressesPerInterface)
      .optionallyWith(
        ipv6AddressesPerInterface.map(value =>
          MaxIpv6AddrPerInterface.unwrap(value): Integer
        )
      )(_.ipv6AddressesPerInterface)
      .optionallyWith(
        ipv6Supported.map(value => Ipv6Flag.unwrap(value): java.lang.Boolean)
      )(_.ipv6Supported)
      .optionallyWith(enaSupport.map(value => value.unwrap))(_.enaSupport)
      .optionallyWith(
        efaSupported.map(value =>
          EfaSupportedFlag.unwrap(value): java.lang.Boolean
        )
      )(_.efaSupported)
      .optionallyWith(efaInfo.map(value => value.buildAwsValue()))(_.efaInfo)
      .optionallyWith(
        encryptionInTransitSupported.map(value =>
          EncryptionInTransitSupported.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionInTransitSupported)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInfo.ReadOnly =
    zio.aws.ec2.model.NetworkInfo.wrap(buildAwsValue())
}
object NetworkInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NetworkInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInfo =
      zio.aws.ec2.model.NetworkInfo(
        networkPerformance.map(value => value),
        maximumNetworkInterfaces.map(value => value),
        maximumNetworkCards.map(value => value),
        defaultNetworkCardIndex.map(value => value),
        networkCards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4AddressesPerInterface.map(value => value),
        ipv6AddressesPerInterface.map(value => value),
        ipv6Supported.map(value => value),
        enaSupport.map(value => value),
        efaSupported.map(value => value),
        efaInfo.map(value => value.asEditable),
        encryptionInTransitSupported.map(value => value)
      )
    def networkPerformance: Option[NetworkPerformance]
    def maximumNetworkInterfaces: Option[MaxNetworkInterfaces]
    def maximumNetworkCards: Option[MaximumNetworkCards]
    def defaultNetworkCardIndex: Option[DefaultNetworkCardIndex]
    def networkCards: Option[List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]]
    def ipv4AddressesPerInterface: Option[MaxIpv4AddrPerInterface]
    def ipv6AddressesPerInterface: Option[MaxIpv6AddrPerInterface]
    def ipv6Supported: Option[Ipv6Flag]
    def enaSupport: Option[zio.aws.ec2.model.EnaSupport]
    def efaSupported: Option[EfaSupportedFlag]
    def efaInfo: Option[zio.aws.ec2.model.EfaInfo.ReadOnly]
    def encryptionInTransitSupported: Option[EncryptionInTransitSupported]
    def getNetworkPerformance: ZIO[Any, AwsError, NetworkPerformance] =
      AwsError.unwrapOptionField("networkPerformance", networkPerformance)
    def getMaximumNetworkInterfaces: ZIO[Any, AwsError, MaxNetworkInterfaces] =
      AwsError.unwrapOptionField(
        "maximumNetworkInterfaces",
        maximumNetworkInterfaces
      )
    def getMaximumNetworkCards: ZIO[Any, AwsError, MaximumNetworkCards] =
      AwsError.unwrapOptionField("maximumNetworkCards", maximumNetworkCards)
    def getDefaultNetworkCardIndex
        : ZIO[Any, AwsError, DefaultNetworkCardIndex] = AwsError
      .unwrapOptionField("defaultNetworkCardIndex", defaultNetworkCardIndex)
    def getNetworkCards
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]] =
      AwsError.unwrapOptionField("networkCards", networkCards)
    def getIpv4AddressesPerInterface
        : ZIO[Any, AwsError, MaxIpv4AddrPerInterface] = AwsError
      .unwrapOptionField("ipv4AddressesPerInterface", ipv4AddressesPerInterface)
    def getIpv6AddressesPerInterface
        : ZIO[Any, AwsError, MaxIpv6AddrPerInterface] = AwsError
      .unwrapOptionField("ipv6AddressesPerInterface", ipv6AddressesPerInterface)
    def getIpv6Supported: ZIO[Any, AwsError, Ipv6Flag] =
      AwsError.unwrapOptionField("ipv6Supported", ipv6Supported)
    def getEnaSupport: ZIO[Any, AwsError, zio.aws.ec2.model.EnaSupport] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getEfaSupported: ZIO[Any, AwsError, EfaSupportedFlag] =
      AwsError.unwrapOptionField("efaSupported", efaSupported)
    def getEfaInfo: ZIO[Any, AwsError, zio.aws.ec2.model.EfaInfo.ReadOnly] =
      AwsError.unwrapOptionField("efaInfo", efaInfo)
    def getEncryptionInTransitSupported
        : ZIO[Any, AwsError, EncryptionInTransitSupported] =
      AwsError.unwrapOptionField(
        "encryptionInTransitSupported",
        encryptionInTransitSupported
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInfo
  ) extends zio.aws.ec2.model.NetworkInfo.ReadOnly {
    override val networkPerformance: Option[NetworkPerformance] = scala
      .Option(impl.networkPerformance())
      .map(value => zio.aws.ec2.model.primitives.NetworkPerformance(value))
    override val maximumNetworkInterfaces: Option[MaxNetworkInterfaces] = scala
      .Option(impl.maximumNetworkInterfaces())
      .map(value => zio.aws.ec2.model.primitives.MaxNetworkInterfaces(value))
    override val maximumNetworkCards: Option[MaximumNetworkCards] = scala
      .Option(impl.maximumNetworkCards())
      .map(value => zio.aws.ec2.model.primitives.MaximumNetworkCards(value))
    override val defaultNetworkCardIndex: Option[DefaultNetworkCardIndex] =
      scala
        .Option(impl.defaultNetworkCardIndex())
        .map(value =>
          zio.aws.ec2.model.primitives.DefaultNetworkCardIndex(value)
        )
    override val networkCards
        : Option[List[zio.aws.ec2.model.NetworkCardInfo.ReadOnly]] = scala
      .Option(impl.networkCards())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkCardInfo.wrap(item)
        }.toList
      )
    override val ipv4AddressesPerInterface: Option[MaxIpv4AddrPerInterface] =
      scala
        .Option(impl.ipv4AddressesPerInterface())
        .map(value =>
          zio.aws.ec2.model.primitives.MaxIpv4AddrPerInterface(value)
        )
    override val ipv6AddressesPerInterface: Option[MaxIpv6AddrPerInterface] =
      scala
        .Option(impl.ipv6AddressesPerInterface())
        .map(value =>
          zio.aws.ec2.model.primitives.MaxIpv6AddrPerInterface(value)
        )
    override val ipv6Supported: Option[Ipv6Flag] = scala
      .Option(impl.ipv6Supported())
      .map(value => zio.aws.ec2.model.primitives.Ipv6Flag(value))
    override val enaSupport: Option[zio.aws.ec2.model.EnaSupport] = scala
      .Option(impl.enaSupport())
      .map(value => zio.aws.ec2.model.EnaSupport.wrap(value))
    override val efaSupported: Option[EfaSupportedFlag] = scala
      .Option(impl.efaSupported())
      .map(value => zio.aws.ec2.model.primitives.EfaSupportedFlag(value))
    override val efaInfo: Option[zio.aws.ec2.model.EfaInfo.ReadOnly] = scala
      .Option(impl.efaInfo())
      .map(value => zio.aws.ec2.model.EfaInfo.wrap(value))
    override val encryptionInTransitSupported
        : Option[EncryptionInTransitSupported] = scala
      .Option(impl.encryptionInTransitSupported())
      .map(value =>
        zio.aws.ec2.model.primitives.EncryptionInTransitSupported(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInfo
  ): zio.aws.ec2.model.NetworkInfo.ReadOnly = new Wrapper(impl)
}
