package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVolumeResponse(
    volumeModification: Option[zio.aws.ec2.model.VolumeModification] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse = {
    import ModifyVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse
      .builder()
      .optionallyWith(volumeModification.map(value => value.buildAwsValue()))(
        _.volumeModification
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVolumeResponse.wrap(buildAwsValue())
}
object ModifyVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVolumeResponse = zio.aws.ec2.model
      .ModifyVolumeResponse(volumeModification.map(value => value.asEditable))
    def volumeModification
        : Option[zio.aws.ec2.model.VolumeModification.ReadOnly]
    def getVolumeModification
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeModification.ReadOnly] =
      AwsError.unwrapOptionField("volumeModification", volumeModification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse
  ) extends zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly {
    override val volumeModification
        : Option[zio.aws.ec2.model.VolumeModification.ReadOnly] = scala
      .Option(impl.volumeModification())
      .map(value => zio.aws.ec2.model.VolumeModification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse
  ): zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly = new Wrapper(impl)
}
