package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{InstanceId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceAttributeRequest(
    sourceDestCheck: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    attribute: Option[zio.aws.ec2.model.InstanceAttributeName] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification]
    ] = None,
    disableApiTermination: Option[zio.aws.ec2.model.AttributeBooleanValue] =
      None,
    ebsOptimized: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    enaSupport: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    groups: Option[Iterable[SecurityGroupId]] = None,
    instanceId: InstanceId,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.AttributeValue
    ] = None,
    instanceType: Option[zio.aws.ec2.model.AttributeValue] = None,
    kernel: Option[zio.aws.ec2.model.AttributeValue] = None,
    ramdisk: Option[zio.aws.ec2.model.AttributeValue] = None,
    sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue] = None,
    userData: Option[zio.aws.ec2.model.BlobAttributeValue] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest = {
    import ModifyInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
      .builder()
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        disableApiTermination.map(value => value.buildAwsValue())
      )(_.disableApiTermination)
      .optionallyWith(ebsOptimized.map(value => value.buildAwsValue()))(
        _.ebsOptimized
      )
      .optionallyWith(enaSupport.map(value => value.buildAwsValue()))(
        _.enaSupport
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.buildAwsValue())
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.buildAwsValue()))(
        _.instanceType
      )
      .optionallyWith(kernel.map(value => value.buildAwsValue()))(_.kernel)
      .optionallyWith(ramdisk.map(value => value.buildAwsValue()))(_.ramdisk)
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceAttributeRequest.wrap(buildAwsValue())
}
object ModifyInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceAttributeRequest =
      zio.aws.ec2.model.ModifyInstanceAttributeRequest(
        sourceDestCheck.map(value => value.asEditable),
        attribute.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableApiTermination.map(value => value.asEditable),
        ebsOptimized.map(value => value.asEditable),
        enaSupport.map(value => value.asEditable),
        groups.map(value => value),
        instanceId,
        instanceInitiatedShutdownBehavior.map(value => value.asEditable),
        instanceType.map(value => value.asEditable),
        kernel.map(value => value.asEditable),
        ramdisk.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        userData.map(value => value.asEditable),
        value.map(value => value)
      )
    def sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def attribute: Option[zio.aws.ec2.model.InstanceAttributeName]
    def blockDeviceMappings: Option[
      List[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly]
    ]
    def disableApiTermination
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def ebsOptimized: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enaSupport: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def groups: Option[List[SecurityGroupId]]
    def instanceId: InstanceId
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def instanceType: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernel: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def ramdisk: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def userData: Option[zio.aws.ec2.model.BlobAttributeValue.ReadOnly]
    def value: Option[String]
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDisableApiTermination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEbsOptimized
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEnaSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernel
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernel", kernel)
    def getRamdisk
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdisk", ramdisk)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getUserData
        : ZIO[Any, AwsError, zio.aws.ec2.model.BlobAttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ) extends zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly {
    override val sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.sourceDestCheck())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val attribute: Option[zio.aws.ec2.model.InstanceAttributeName] =
      scala
        .Option(impl.attribute())
        .map(value => zio.aws.ec2.model.InstanceAttributeName.wrap(value))
    override val blockDeviceMappings: Option[
      List[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.wrap(item)
        }.toList
      )
    override val disableApiTermination
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.disableApiTermination())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val ebsOptimized
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.ebsOptimized())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enaSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enaSupport())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val groups: Option[List[SecurityGroupId]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val instanceType
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernel: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.kernel())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val ramdisk: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.ramdisk())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sriovNetSupport
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.sriovNetSupport())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val userData
        : Option[zio.aws.ec2.model.BlobAttributeValue.ReadOnly] = scala
      .Option(impl.userData())
      .map(value => zio.aws.ec2.model.BlobAttributeValue.wrap(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ): zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
