package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClientVpnEndpointResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse = {
    import ModifyClientVpnEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly =
    zio.aws.ec2.model.ModifyClientVpnEndpointResponse.wrap(buildAwsValue())
}
object ModifyClientVpnEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyClientVpnEndpointResponse =
      zio.aws.ec2.model
        .ModifyClientVpnEndpointResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse
  ) extends zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse
  ): zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
