package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MemoryMiB(
    min: Option[Integer] = None,
    max: Option[Integer] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.MemoryMiB = {
    import MemoryMiB.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MemoryMiB
      .builder()
      .optionallyWith(
        min.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.min)
      .optionallyWith(
        max.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MemoryMiB.ReadOnly =
    zio.aws.ec2.model.MemoryMiB.wrap(buildAwsValue())
}
object MemoryMiB {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.MemoryMiB] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MemoryMiB = zio.aws.ec2.model
      .MemoryMiB(min.map(value => value), max.map(value => value))
    def min: Option[Integer]
    def max: Option[Integer]
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MemoryMiB
  ) extends zio.aws.ec2.model.MemoryMiB.ReadOnly {
    override val min: Option[Integer] = scala
      .Option(impl.min())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val max: Option[Integer] = scala
      .Option(impl.max())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MemoryMiB
  ): zio.aws.ec2.model.MemoryMiB.ReadOnly = new Wrapper(impl)
}
