package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayRoutetableId,
  LocalGatewayVirtualInterfaceGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocalGatewayRoute(
    destinationCidrBlock: Option[String] = None,
    localGatewayVirtualInterfaceGroupId: Option[
      LocalGatewayVirtualInterfaceGroupId
    ] = None,
    `type`: Option[zio.aws.ec2.model.LocalGatewayRouteType] = None,
    state: Option[zio.aws.ec2.model.LocalGatewayRouteState] = None,
    localGatewayRouteTableId: Option[LocalGatewayRoutetableId] = None,
    localGatewayRouteTableArn: Option[ResourceArn] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRoute = {
    import LocalGatewayRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayRoutetableId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayRoute.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRoute.wrap(buildAwsValue())
}
object LocalGatewayRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRoute =
      zio.aws.ec2.model.LocalGatewayRoute(
        destinationCidrBlock.map(value => value),
        localGatewayVirtualInterfaceGroupId.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        ownerId.map(value => value)
      )
    def destinationCidrBlock: Option[String]
    def localGatewayVirtualInterfaceGroupId
        : Option[LocalGatewayVirtualInterfaceGroupId]
    def `type`: Option[zio.aws.ec2.model.LocalGatewayRouteType]
    def state: Option[zio.aws.ec2.model.LocalGatewayRouteState]
    def localGatewayRouteTableId: Option[LocalGatewayRoutetableId]
    def localGatewayRouteTableArn: Option[ResourceArn]
    def ownerId: Option[String]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteState] =
      AwsError.unwrapOptionField("state", state)
    def getLocalGatewayRouteTableId
        : ZIO[Any, AwsError, LocalGatewayRoutetableId] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ) extends zio.aws.ec2.model.LocalGatewayRoute.ReadOnly {
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val localGatewayVirtualInterfaceGroupId
        : Option[LocalGatewayVirtualInterfaceGroupId] = scala
      .Option(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val `type`: Option[zio.aws.ec2.model.LocalGatewayRouteType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.LocalGatewayRouteType.wrap(value))
    override val state: Option[zio.aws.ec2.model.LocalGatewayRouteState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.LocalGatewayRouteState.wrap(value))
    override val localGatewayRouteTableId: Option[LocalGatewayRoutetableId] =
      scala
        .Option(impl.localGatewayRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(value)
        )
    override val localGatewayRouteTableArn: Option[ResourceArn] = scala
      .Option(impl.localGatewayRouteTableArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRoute
  ): zio.aws.ec2.model.LocalGatewayRoute.ReadOnly = new Wrapper(impl)
}
