package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterfaceSpecification(
    associatePublicIpAddress: Option[Boolean] = None,
    deleteOnTermination: Option[Boolean] = None,
    description: Option[String] = None,
    deviceIndex: Option[Integer] = None,
    groups: Option[Iterable[SecurityGroupId]] = None,
    ipv6AddressCount: Option[Integer] = None,
    ipv6Addresses: Option[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    privateIpAddress: Option[String] = None,
    privateIpAddresses: Option[
      Iterable[zio.aws.ec2.model.PrivateIpAddressSpecification]
    ] = None,
    secondaryPrivateIpAddressCount: Option[Integer] = None,
    subnetId: Option[String] = None,
    associateCarrierIpAddress: Option[Boolean] = None,
    interfaceType: Option[String] = None,
    networkCardIndex: Option[Integer] = None,
    ipv4Prefixes: Option[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest]
    ] = None,
    ipv4PrefixCount: Option[Integer] = None,
    ipv6Prefixes: Option[
      Iterable[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest]
    ] = None,
    ipv6PrefixCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification = {
    import InstanceNetworkInterfaceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification
      .builder()
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        deviceIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.deviceIndex)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        ipv6AddressCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ipv6AddressCount)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(
        associateCarrierIpAddress.map(value => value: java.lang.Boolean)
      )(_.associateCarrierIpAddress)
      .optionallyWith(interfaceType.map(value => value: java.lang.String))(
        _.interfaceType
      )
      .optionallyWith(
        networkCardIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.networkCardIndex)
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(
        ipv4PrefixCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ipv4PrefixCount)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(
        ipv6PrefixCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ipv6PrefixCount)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterfaceSpecification
      .wrap(buildAwsValue())
}
object InstanceNetworkInterfaceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterfaceSpecification =
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification(
        associatePublicIpAddress.map(value => value),
        deleteOnTermination.map(value => value),
        description.map(value => value),
        deviceIndex.map(value => value),
        groups.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondaryPrivateIpAddressCount.map(value => value),
        subnetId.map(value => value),
        associateCarrierIpAddress.map(value => value),
        interfaceType.map(value => value),
        networkCardIndex.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4PrefixCount.map(value => value),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6PrefixCount.map(value => value)
      )
    def associatePublicIpAddress: Option[Boolean]
    def deleteOnTermination: Option[Boolean]
    def description: Option[String]
    def deviceIndex: Option[Integer]
    def groups: Option[List[SecurityGroupId]]
    def ipv6AddressCount: Option[Integer]
    def ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def privateIpAddress: Option[String]
    def privateIpAddresses
        : Option[List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]]
    def secondaryPrivateIpAddressCount: Option[Integer]
    def subnetId: Option[String]
    def associateCarrierIpAddress: Option[Boolean]
    def interfaceType: Option[String]
    def networkCardIndex: Option[Integer]
    def ipv4Prefixes: Option[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv4PrefixCount: Option[Integer]
    def ipv6Prefixes: Option[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ]
    def ipv6PrefixCount: Option[Integer]
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getAssociateCarrierIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associateCarrierIpAddress", associateCarrierIpAddress)
    def getInterfaceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification
  ) extends zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly {
    override val associatePublicIpAddress: Option[Boolean] =
      scala.Option(impl.associatePublicIpAddress()).map(value => value: Boolean)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val deviceIndex: Option[Integer] = scala
      .Option(impl.deviceIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val groups: Option[List[SecurityGroupId]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val ipv6AddressCount: Option[Integer] = scala
      .Option(impl.ipv6AddressCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipv6Addresses
        : Option[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
        }.toList
      )
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val privateIpAddresses: Option[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrivateIpAddressSpecification.wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Option[Integer] = scala
      .Option(impl.secondaryPrivateIpAddressCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val associateCarrierIpAddress: Option[Boolean] = scala
      .Option(impl.associateCarrierIpAddress())
      .map(value => value: Boolean)
    override val interfaceType: Option[String] =
      scala.Option(impl.interfaceType()).map(value => value: String)
    override val networkCardIndex: Option[Integer] = scala
      .Option(impl.networkCardIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipv4Prefixes: Option[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly]
    ] = scala
      .Option(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv4PrefixCount: Option[Integer] = scala
      .Option(impl.ipv4PrefixCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipv6Prefixes: Option[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.ReadOnly]
    ] = scala
      .Option(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6PrefixSpecificationRequest.wrap(item)
        }.toList
      )
    override val ipv6PrefixCount: Option[Integer] = scala
      .Option(impl.ipv6PrefixCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification
  ): zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly =
    new Wrapper(impl)
}
