package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterfaceAssociation(
    carrierIp: Option[String] = None,
    customerOwnedIp: Option[String] = None,
    ipOwnerId: Option[String] = None,
    publicDnsName: Option[String] = None,
    publicIp: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation = {
    import InstanceNetworkInterfaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
      .builder()
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(ipOwnerId.map(value => value: java.lang.String))(
        _.ipOwnerId
      )
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.wrap(buildAwsValue())
}
object InstanceNetworkInterfaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterfaceAssociation =
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation(
        carrierIp.map(value => value),
        customerOwnedIp.map(value => value),
        ipOwnerId.map(value => value),
        publicDnsName.map(value => value),
        publicIp.map(value => value)
      )
    def carrierIp: Option[String]
    def customerOwnedIp: Option[String]
    def ipOwnerId: Option[String]
    def publicDnsName: Option[String]
    def publicIp: Option[String]
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getIpOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipOwnerId", ipOwnerId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ) extends zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly {
    override val carrierIp: Option[String] =
      scala.Option(impl.carrierIp()).map(value => value: String)
    override val customerOwnedIp: Option[String] =
      scala.Option(impl.customerOwnedIp()).map(value => value: String)
    override val ipOwnerId: Option[String] =
      scala.Option(impl.ipOwnerId()).map(value => value: String)
    override val publicDnsName: Option[String] =
      scala.Option(impl.publicDnsName()).map(value => value: String)
    override val publicIp: Option[String] =
      scala.Option(impl.publicIp()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ): zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly =
    new Wrapper(impl)
}
