package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFamilyCreditSpecification(
    instanceFamily: Option[zio.aws.ec2.model.UnlimitedSupportedInstanceFamily] =
      None,
    cpuCredits: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceFamilyCreditSpecification = {
    import InstanceFamilyCreditSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceFamilyCreditSpecification
      .builder()
      .optionallyWith(instanceFamily.map(value => value.unwrap))(
        _.instanceFamily
      )
      .optionallyWith(cpuCredits.map(value => value: java.lang.String))(
        _.cpuCredits
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly =
    zio.aws.ec2.model.InstanceFamilyCreditSpecification.wrap(buildAwsValue())
}
object InstanceFamilyCreditSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceFamilyCreditSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceFamilyCreditSpecification =
      zio.aws.ec2.model.InstanceFamilyCreditSpecification(
        instanceFamily.map(value => value),
        cpuCredits.map(value => value)
      )
    def instanceFamily
        : Option[zio.aws.ec2.model.UnlimitedSupportedInstanceFamily]
    def cpuCredits: Option[String]
    def getInstanceFamily: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.UnlimitedSupportedInstanceFamily
    ] = AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getCpuCredits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpuCredits", cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceFamilyCreditSpecification
  ) extends zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly {
    override val instanceFamily
        : Option[zio.aws.ec2.model.UnlimitedSupportedInstanceFamily] = scala
      .Option(impl.instanceFamily())
      .map(value =>
        zio.aws.ec2.model.UnlimitedSupportedInstanceFamily.wrap(value)
      )
    override val cpuCredits: Option[String] =
      scala.Option(impl.cpuCredits()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceFamilyCreditSpecification
  ): zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly = new Wrapper(
    impl
  )
}
