package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportImageTask(
    architecture: Option[String] = None,
    description: Option[String] = None,
    encrypted: Option[Boolean] = None,
    hypervisor: Option[String] = None,
    imageId: Option[String] = None,
    importTaskId: Option[String] = None,
    kmsKeyId: Option[String] = None,
    licenseType: Option[String] = None,
    platform: Option[String] = None,
    progress: Option[String] = None,
    snapshotDetails: Option[Iterable[zio.aws.ec2.model.SnapshotDetail]] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse]
    ] = None,
    usageOperation: Option[String] = None,
    bootMode: Option[zio.aws.ec2.model.BootModeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageTask = {
    import ImportImageTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageTask
      .builder()
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(hypervisor.map(value => value: java.lang.String))(
        _.hypervisor
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(licenseType.map(value => value: java.lang.String))(
        _.licenseType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        snapshotDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotDetails)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportImageTask.ReadOnly =
    zio.aws.ec2.model.ImportImageTask.wrap(buildAwsValue())
}
object ImportImageTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageTask =
      zio.aws.ec2.model.ImportImageTask(
        architecture.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        hypervisor.map(value => value),
        imageId.map(value => value),
        importTaskId.map(value => value),
        kmsKeyId.map(value => value),
        licenseType.map(value => value),
        platform.map(value => value),
        progress.map(value => value),
        snapshotDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageOperation.map(value => value),
        bootMode.map(value => value)
      )
    def architecture: Option[String]
    def description: Option[String]
    def encrypted: Option[Boolean]
    def hypervisor: Option[String]
    def imageId: Option[String]
    def importTaskId: Option[String]
    def kmsKeyId: Option[String]
    def licenseType: Option[String]
    def platform: Option[String]
    def progress: Option[String]
    def snapshotDetails: Option[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]]
    def status: Option[String]
    def statusMessage: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ]
    def usageOperation: Option[String]
    def bootMode: Option[zio.aws.ec2.model.BootModeValues]
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHypervisor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLicenseType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] =
      AwsError.unwrapOptionField("snapshotDetails", snapshotDetails)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageTask
  ) extends zio.aws.ec2.model.ImportImageTask.ReadOnly {
    override val architecture: Option[String] =
      scala.Option(impl.architecture()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val hypervisor: Option[String] =
      scala.Option(impl.hypervisor()).map(value => value: String)
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val importTaskId: Option[String] =
      scala.Option(impl.importTaskId()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val licenseType: Option[String] =
      scala.Option(impl.licenseType()).map(value => value: String)
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val snapshotDetails
        : Option[List[zio.aws.ec2.model.SnapshotDetail.ReadOnly]] = scala
      .Option(impl.snapshotDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SnapshotDetail.wrap(item)
        }.toList
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.ReadOnly]
    ] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageLicenseConfigurationResponse.wrap(item)
        }.toList
      )
    override val usageOperation: Option[String] =
      scala.Option(impl.usageOperation()).map(value => value: String)
    override val bootMode: Option[zio.aws.ec2.model.BootModeValues] = scala
      .Option(impl.bootMode())
      .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageTask
  ): zio.aws.ec2.model.ImportImageTask.ReadOnly = new Wrapper(impl)
}
