package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportImageLicenseConfigurationRequest(
    licenseConfigurationArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest = {
    import ImportImageLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ImportImageLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object ImportImageLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageLicenseConfigurationRequest =
      zio.aws.ec2.model.ImportImageLicenseConfigurationRequest(
        licenseConfigurationArn.map(value => value)
      )
    def licenseConfigurationArn: Option[String]
    def getLicenseConfigurationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("licenseConfigurationArn", licenseConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest
  ) extends zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly {
    override val licenseConfigurationArn: Option[String] =
      scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationRequest
  ): zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
