package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetConsoleOutputResponse(
    instanceId: Option[String] = None,
    output: Option[String] = None,
    timestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse = {
    import GetConsoleOutputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(output.map(value => value: java.lang.String))(_.output)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly =
    zio.aws.ec2.model.GetConsoleOutputResponse.wrap(buildAwsValue())
}
object GetConsoleOutputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetConsoleOutputResponse =
      zio.aws.ec2.model.GetConsoleOutputResponse(
        instanceId.map(value => value),
        output.map(value => value),
        timestamp.map(value => value)
      )
    def instanceId: Option[String]
    def output: Option[String]
    def timestamp: Option[DateTime]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getOutput: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("output", output)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse
  ) extends zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly {
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val output: Option[String] =
      scala.Option(impl.output()).map(value => value: String)
    override val timestamp: Option[DateTime] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse
  ): zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly = new Wrapper(impl)
}
