package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateOverridesRequest(
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    maxPrice: Option[String] = None,
    subnetId: Option[SubnetId] = None,
    availabilityZone: Option[String] = None,
    weightedCapacity: Option[Double] = None,
    priority: Option[Double] = None,
    placement: Option[zio.aws.ec2.model.Placement] = None,
    instanceRequirements: Option[
      zio.aws.ec2.model.InstanceRequirementsRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest = {
    import FleetLaunchTemplateOverridesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(maxPrice.map(value => value: java.lang.String))(
        _.maxPrice
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(priority.map(value => value: java.lang.Double))(
        _.priority
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.wrap(buildAwsValue())
}
object FleetLaunchTemplateOverridesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest =
      zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest(
        instanceType.map(value => value),
        maxPrice.map(value => value),
        subnetId.map(value => value),
        availabilityZone.map(value => value),
        weightedCapacity.map(value => value),
        priority.map(value => value),
        placement.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable)
      )
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def maxPrice: Option[String]
    def subnetId: Option[SubnetId]
    def availabilityZone: Option[String]
    def weightedCapacity: Option[Double]
    def priority: Option[Double]
    def placement: Option[zio.aws.ec2.model.Placement.ReadOnly]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getPriority: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("priority", priority)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getInstanceRequirements: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest
  ) extends zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly {
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val maxPrice: Option[String] =
      scala.Option(impl.maxPrice()).map(value => value: String)
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val weightedCapacity: Option[Double] =
      scala.Option(impl.weightedCapacity()).map(value => value: Double)
    override val priority: Option[Double] =
      scala.Option(impl.priority()).map(value => value: Double)
    override val placement: Option[zio.aws.ec2.model.Placement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirementsRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest
  ): zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest.ReadOnly =
    new Wrapper(impl)
}
