package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EndDateType {
  def unwrap: software.amazon.awssdk.services.ec2.model.EndDateType
}
object EndDateType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EndDateType
  ): zio.aws.ec2.model.EndDateType = value match {
    case software.amazon.awssdk.services.ec2.model.EndDateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EndDateType.UNLIMITED =>
      val r = unlimited
      r
    case software.amazon.awssdk.services.ec2.model.EndDateType.LIMITED =>
      val r = limited
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.EndDateType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EndDateType =
      software.amazon.awssdk.services.ec2.model.EndDateType.UNKNOWN_TO_SDK_VERSION
  }
  case object unlimited extends zio.aws.ec2.model.EndDateType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EndDateType =
      software.amazon.awssdk.services.ec2.model.EndDateType.UNLIMITED
  }
  case object limited extends zio.aws.ec2.model.EndDateType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EndDateType =
      software.amazon.awssdk.services.ec2.model.EndDateType.LIMITED
  }
}
