package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableTransitGatewayRouteTablePropagationRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest = {
    import DisableTransitGatewayRouteTablePropagationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
      .wrap(buildAwsValue())
}
object DisableTransitGatewayRouteTablePropagationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest =
      zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest(
        transitGatewayRouteTableId,
        transitGatewayAttachmentId
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ) extends zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ): zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    new Wrapper(impl)
}
